/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.input;

import java.util.function.Supplier;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.input.ProcessingInputTracker;
import mod.chiselsandbits.network.packets.InputTrackerStatusUpdatePacket;
import mod.chiselsandbits.platforms.core.dist.Dist;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import net.minecraft.class_1657;
import net.minecraft.class_310;

public final class FrameBasedInputTracker {
    private static final FrameBasedInputTracker INSTANCE = new FrameBasedInputTracker();
    private final InputTracker leftMouseTracker = new InputTracker(() -> (Boolean)DistExecutor.runForDist(() -> () -> class_310.method_1551().field_1690.field_1886.method_1434(), () -> () -> false), () -> {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new InputTrackerStatusUpdatePacket(true, true));
        DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> ProcessingInputTracker.getInstance().onStartedLeftClicking((class_1657)class_310.method_1551().field_1724));
    }, () -> {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new InputTrackerStatusUpdatePacket(true, false));
        DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> ProcessingInputTracker.getInstance().onStoppedLeftClicking((class_1657)class_310.method_1551().field_1724));
    });
    private final InputTracker rightMouseTracker = new InputTracker(() -> (Boolean)DistExecutor.runForDist(() -> () -> class_310.method_1551().field_1690.field_1904.method_1434(), () -> () -> false), () -> {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new InputTrackerStatusUpdatePacket(false, true));
        DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> ProcessingInputTracker.getInstance().onStartedRightClicking((class_1657)class_310.method_1551().field_1724));
    }, () -> {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new InputTrackerStatusUpdatePacket(false, false));
        DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> ProcessingInputTracker.getInstance().onStoppedRightClicking((class_1657)class_310.method_1551().field_1724));
    });

    public static FrameBasedInputTracker getInstance() {
        return INSTANCE;
    }

    private FrameBasedInputTracker() {
    }

    public void onRenderFrame() {
        this.leftMouseTracker.tick();
        this.rightMouseTracker.tick();
    }

    private static final class InputTracker {
        private final Supplier<Boolean> isActiveChecker;
        private final Runnable onToggleOn;
        private final Runnable onToggleOff;
        private boolean isActive = false;

        private InputTracker(Supplier<Boolean> isActiveChecker, Runnable onToggleOn, Runnable onToggleOff) {
            this.isActiveChecker = isActiveChecker;
            this.onToggleOn = onToggleOn;
            this.onToggleOff = onToggleOff;
        }

        public void tick() {
            boolean newPotentialState = this.isActiveChecker.get();
            if (this.isActive && !newPotentialState) {
                this.onToggleOff.run();
                this.isActive = false;
            } else if (!this.isActive && newPotentialState) {
                this.onToggleOn.run();
                this.isActive = true;
            }
        }
    }
}

